<?php
/**
 * Plugin Name: Optioner
 * Description: Minimal option framework.
 * Version: 1.0.9
 * Author: Nilambar Sharma
 * Author URI: https://www.nilambar.net
 * Text Domain: optioner
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 *
 * @package Optioner
 */

namespace Nilambar\Optioner;

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

define( 'OPTIONER_BASENAME', basename( dirname( __FILE__ ) ) );
define( 'OPTIONER_DIR', rtrim( plugin_dir_path( __FILE__ ), '/' ) );
define( 'OPTIONER_URL', rtrim( plugin_dir_url( __FILE__ ), '/' ) );

require_once OPTIONER_DIR . '/src/Optioner.php';

$obj = new Optioner();

$obj->set_page();

$obj->add_tab(
	array(
		'id'    => 'basic_tab',
		'title' => esc_html__( 'Basic', 'ns-category-widget' ),
	)
);

// Field: sample_heading.
$obj->add_field(
	'basic_tab',
	array(
		'id'          => 'sample_heading',
		'type'        => 'heading',
		'title'       => esc_html__( 'Sample Heading', 'ns-category-widget' ),
		'description' => esc_html__( 'This is description.', 'ns-category-widget' ),
	)
);

// Field: sample_text.
$obj->add_field(
	'basic_tab',
	array(
		'id'          => 'sample_text',
		'type'        => 'text',
		'title'       => esc_html__( 'Sample Text', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for sample text.', 'ns-category-widget' ),
		'placeholder' => esc_html__( 'Enter text', 'ns-category-widget' ),
	)
);

// Field: sample_checkbox.
$obj->add_field(
	'basic_tab',
	array(
		'id'          => 'sample_checkbox',
		'type'        => 'checkbox',
		'default'     => true,
		'title'       => esc_html__( 'Sample Checkbox', 'ns-category-widget' ),
		'side_text'   => esc_html__( 'Enable sample checkbox', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for sample checkbox field.', 'ns-category-widget' ),
	)
);

// Field: sample_select.
$obj->add_field(
	'basic_tab',
	array(
		'id'          => 'sample_select',
		'type'        => 'select',
		'title'       => esc_html__( 'Sample Select', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of sample select.', 'ns-category-widget' ),
		'choices'     => array(
			'1' => esc_html__( 'First', 'ns-category-widget' ),
			'2' => esc_html__( 'Second', 'ns-category-widget' ),
			'3' => esc_html__( 'Third', 'ns-category-widget' ),
		),
	)
);

// Field: sample_radio.
$obj->add_field(
	'basic_tab',
	array(
		'id'          => 'sample_radio',
		'type'        => 'radio',
		'title'       => esc_html__( 'Sample Radio', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of sample radio.', 'ns-category-widget' ),
		'default'     => '1',
		'choices'     => array(
			'1' => esc_html__( 'First', 'ns-category-widget' ),
			'2' => esc_html__( 'Second', 'ns-category-widget' ),
		),
	)
);

// Field: sample_image.
$obj->add_field(
	'basic_tab',
	array(
		'id'          => 'sample_image',
		'type'        => 'image',
		'title'       => esc_html__( 'Sample Image', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for sample image.', 'ns-category-widget' ),
	)
);

// Field: sample_color.
$obj->add_field(
	'basic_tab',
	array(
		'id'          => 'sample_color',
		'type'        => 'color',
		'title'       => esc_html__( 'Sample Color', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of sample color.', 'ns-category-widget' ),
		'default'     => '#8224e3',
	)
);

$obj->add_tab(
	array(
		'id'    => 'text_tab',
		'title' => esc_html__( 'Text', 'ns-category-widget' ),
	)
);

// Field: text_regular.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'text_regular',
		'type'        => 'text',
		'title'       => esc_html__( 'Text Regular', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of text regular.', 'ns-category-widget' ),
	)
);

// Field: text_small.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'text_small',
		'type'        => 'text',
		'title'       => esc_html__( 'Text Small', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of text small.', 'ns-category-widget' ),
		'class'       => 'small-text',
	)
);

// Field: text_tiny.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'text_tiny',
		'type'        => 'text',
		'title'       => esc_html__( 'Text Tiny', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of text tiny.', 'ns-category-widget' ),
		'class'       => 'tiny-text',
	)
);

// Field: text_large.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'text_large',
		'type'        => 'text',
		'title'       => esc_html__( 'Text Large', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of text large.', 'ns-category-widget' ),
		'class'       => 'large-text',
	)
);

// Field: text_password.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'text_password',
		'type'        => 'password',
		'title'       => esc_html__( 'Text Password', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of text password.', 'ns-category-widget' ),
	)
);

// Field: sample_url.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'sample_url',
		'type'        => 'url',
		'title'       => esc_html__( 'Sample URL', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of sample URL.', 'ns-category-widget' ),
		'placeholder' => esc_html__( 'Enter full URL.', 'ns-category-widget' ),
	)
);

// Field: sample_number.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'sample_number',
		'type'        => 'number',
		'title'       => esc_html__( 'Sample Number', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of sample number.', 'ns-category-widget' ),
	)
);

// Field: sample_email.
$obj->add_field(
	'text_tab',
	array(
		'id'          => 'sample_email',
		'type'        => 'email',
		'title'       => esc_html__( 'Sample Email', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of sample email.', 'ns-category-widget' ),
	)
);

// Tab: textarea_tab.
$obj->add_tab(
	array(
		'id'    => 'textarea_tab',
		'title' => esc_html__( 'Textarea', 'ns-category-widget' ),
	)
);

// Field: textarea_regular.
$obj->add_field(
	'textarea_tab',
	array(
		'id'          => 'textarea_regular',
		'type'        => 'textarea',
		'title'       => esc_html__( 'Textarea Regular', 'ns-category-widget' ),
		'description' => esc_html__( 'This is regular textarea.', 'ns-category-widget' ),
		'placeholder' => esc_html__( 'Enter content.', 'ns-category-widget' ),
	)
);

// Field: textarea_large.
$obj->add_field(
	'textarea_tab',
	array(
		'id'          => 'textarea_large',
		'type'        => 'textarea',
		'title'       => esc_html__( 'Textarea Large', 'ns-category-widget' ),
		'description' => esc_html__( 'This is large textarea.', 'ns-category-widget' ),
		'placeholder' => esc_html__( 'Enter content.', 'ns-category-widget' ),
		'class'       => 'large-text',
	)
);

// Tab: checkbox_tab.
$obj->add_tab(
	array(
		'id'    => 'checkbox_tab',
		'title' => esc_html__( 'Checkbox', 'ns-category-widget' ),
	)
);

// Field: checkbox_single.
$obj->add_field(
	'checkbox_tab',
	array(
		'id'          => 'checkbox_single',
		'type'        => 'checkbox',
		'default'     => true,
		'title'       => esc_html__( 'Checkbox Simple', 'ns-category-widget' ),
		'side_text'   => esc_html__( 'Enable simple checkbox', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for simple checkbox field.', 'ns-category-widget' ),
	)
);

// Field: checkbox_multi.
$obj->add_field(
	'checkbox_tab',
	array(
		'id'          => 'checkbox_multi',
		'type'        => 'multicheck',
		'title'       => esc_html__( 'Checkbox Multiple', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for checkbox multiple.', 'ns-category-widget' ),
		'choices'     => array(
			'1' => esc_html__( 'First', 'ns-category-widget' ),
			'2' => esc_html__( 'Second', 'ns-category-widget' ),
			'3' => esc_html__( 'Third', 'ns-category-widget' ),
			'4' => esc_html__( 'Fourth', 'ns-category-widget' ),
		),
	)
);

// Tab: selection_tab.
$obj->add_tab(
	array(
		'id'    => 'selection_tab',
		'title' => esc_html__( 'Selection', 'ns-category-widget' ),
	)
);

// Field: select_simple.
$obj->add_field(
	'selection_tab',
	array(
		'id'          => 'select_simple',
		'type'        => 'select',
		'title'       => esc_html__( 'Select Simple', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of select simple.', 'ns-category-widget' ),
		'choices'     => array(
			'1' => esc_html__( 'First', 'ns-category-widget' ),
			'2' => esc_html__( 'Second', 'ns-category-widget' ),
			'3' => esc_html__( 'Third', 'ns-category-widget' ),
		),
	)
);

// Field: select_null_allowed.
$obj->add_field(
	'selection_tab',
	array(
		'id'          => 'select_null_allowed',
		'type'        => 'select',
		'title'       => esc_html__( 'Select Null Allowed', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of select null allowed.', 'ns-category-widget' ),
		'allow_null'  => true,
		'choices'     => array(
			'1' => esc_html__( 'First', 'ns-category-widget' ),
			'2' => esc_html__( 'Second', 'ns-category-widget' ),
			'3' => esc_html__( 'Third', 'ns-category-widget' ),
		),
	)
);

// Field: radio_horizontal.
$obj->add_field(
	'selection_tab',
	array(
		'id'          => 'radio_horizontal',
		'type'        => 'radio',
		'layout'      => 'horizontal',
		'title'       => esc_html__( 'Radio Horizontal', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of radio horizontal.', 'ns-category-widget' ),
		'default'     => '1',
		'choices'     => array(
			'1' => esc_html__( 'First', 'ns-category-widget' ),
			'2' => esc_html__( 'Second', 'ns-category-widget' ),
			'3' => esc_html__( 'Third', 'ns-category-widget' ),
		),
	)
);

// Field: radio_vertical.
$obj->add_field(
	'selection_tab',
	array(
		'id'          => 'radio_vertical',
		'type'        => 'radio',
		'title'       => esc_html__( 'Radio Vertical', 'ns-category-widget' ),
		'description' => esc_html__( 'Description of radio vertical.', 'ns-category-widget' ),
		'default'     => '1',
		'choices'     => array(
			'1' => esc_html__( 'First', 'ns-category-widget' ),
			'2' => esc_html__( 'Second', 'ns-category-widget' ),
			'3' => esc_html__( 'Third', 'ns-category-widget' ),
		),
	)
);

// Tab: editor_tab.
$obj->add_tab(
	array(
		'id'    => 'editor_tab',
		'title' => esc_html__( 'Editor', 'ns-category-widget' ),
	)
);

// Field: editor_visual_only.
$obj->add_field(
	'editor_tab',
	array(
		'id'          => 'editor_visual_only',
		'type'        => 'editor',
		'title'       => esc_html__( 'Editor Visual Mode Only', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for editor visual mode only.', 'ns-category-widget' ),
		'size'        => 460, // Max width, in px.
		'settings'    => array(
			'textarea_rows' => 5,
			'media_buttons' => false,
			'quicktags'     => false,
		),
	)
);

// Field: editor_text_only.
$obj->add_field(
	'editor_tab',
	array(
		'id'          => 'editor_text_only',
		'type'        => 'editor',
		'title'       => esc_html__( 'Editor Text Mode Only', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for editor text mode only.', 'ns-category-widget' ),
		'size'        => 460, // Max width, in px.
		'settings'    => array(
			'textarea_rows' => 5,
			'media_buttons' => false,
			'tinymce'       => false,
		),
	)
);

// Field: editor_small.
$obj->add_field(
	'editor_tab',
	array(
		'id'          => 'editor_small',
		'type'        => 'editor',
		'title'       => esc_html__( 'Editor Small', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for editor small.', 'ns-category-widget' ),
		'size'        => 460, // Max width, in px.
		'settings'    => array(
			'textarea_rows' => 5,
			'media_buttons' => false,
		),
	)
);

// Field: editor_large.
$obj->add_field(
	'editor_tab',
	array(
		'id'          => 'editor_large',
		'type'        => 'editor',
		'title'       => esc_html__( 'Editor Large', 'ns-category-widget' ),
		'description' => esc_html__( 'Description for editor large.', 'ns-category-widget' ),
	)
);

// Tab: features_tab.
$obj->add_tab(
	array(
		'id'              => 'features_tab',
		'title'           => esc_html__( 'Features', 'ns-category-widget' ),
		'render_callback' => __NAMESPACE__ . '\optioner_render_features_tab',
	)
);

// Set sidebar.
$obj->set_sidebar(
	array(
		'render_callback' => __NAMESPACE__ . '\optioner_render_sidebar',
	)
);

// Render now.
$obj->run();

/**
 * Render features tab.
 *
 * @since 1.0.0
 */
function optioner_render_features_tab() {
	?>
	<p>This is a demonstration of custom tab. You can add anything here. Lorem ipsum dolor sit amet, consectetur adipisicing elit. Eos quia eveniet fugiat nihil voluptatum, laborum alias reprehenderit, modi dicta repudiandae, officia repellat fuga cum optio sit culpa nemo quibusdam. Perspiciatis.</p>
	<p>Ipsum dolor sit amet, consectetur adipisicing elit. Eos quia eveniet fugiat nihil voluptatum, laborum alias reprehenderit, modi dicta repudiandae, officia repellat fuga cum optio sit culpa nemo quibusdam. Perspiciatis.</p>
	<?php
}

/**
 * Render features tab.
 *
 * @since 1.0.0
 */
function optioner_render_sidebar() {
	?>
	<div class="sidebox">
		<h3 class="box-heading">Help &amp; Support</h3>
		<div class="box-content">
			<ul>
				<li><strong>Questions, bugs, or great ideas?</strong></li>
				<li><a href="https://github.com/ernilambar/optioner/issues" target="_blank">Create issue in the repo</a></li>
			</ul>
		</div>
	</div>
	<div class="sidebox">
		<h3 class="box-heading">Sample Links</h3>
		<div class="box-content">
			<p>Lorem ipsum dolor sit amet, conse ctetur adipiscing elit.</p>
			<ul>
				<li><strong>Important links</strong></li>
				<li><a href="#">Sample Link One</a></li>
				<li><a href="#">Sample Link Two</a></li>
				<li><a href="#">Sample Link Three</a></li>
				<li><a href="#">Sample Link Four</a></li>
				<li><a href="#">Sample Link Five</a></li>
			</ul>
		</div>
	</div>
	<?php
}
