<?php
/**
 * Template part for displaying posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.2
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php
	if ( is_sticky() && is_home() ) :
		echo twentyseventeen_get_svg( array( 'icon' => 'thumb-tack' ) );
	endif;
	?>
	<header class="entry-header">
		<?php
		if ( 'post' === get_post_type() ) {
			echo '<div class="entry-meta">';
				if ( is_single() ) {
					/*twentyseventeen_posted_on();*/
				} else {
					/*echo twentyseventeen_time_link();*/
					/*twentyseventeen_edit_link();*/
				};
			echo '</div><!-- .entry-meta -->';
		};

		if ( is_single() ) {
			the_title( '<h1 class="entry-title">', '</h1>' );
		} elseif ( is_front_page() && is_home() ) {
			the_title( '<h3 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h3>' );
		} else {
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		}
		?>
	</header><!-- .entry-header -->

	<?php if ( '' !== get_the_post_thumbnail() && ! is_single() ) : ?>
		<div class="post-thumbnail">
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail( 'twentyseventeen-featured-image' ); ?>
			</a>
		</div><!-- .post-thumbnail -->
	<?php endif; ?>

	<div class="entry-content">
		<?php
		/* translators: %s: Name of current post */
		the_content( sprintf(
			__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'twentyseventeen' ),
			get_the_title()
		) );
	
	
		wp_link_pages( array(
			'before'      => '<div class="page-links">' . __( 'Pages:', 'twentyseventeen' ),
			'after'       => '</div>',
			'link_before' => '<span class="page-number">',
			'link_after'  => '</span>',
		) );
		?>
	</div><!-- .entry-content -->

	<?php
	if ( is_single() ) {
			if(get_field('date_de_publication'))
			{
				echo '<p><h4>DATE DE PUBLICATION</h4>' . get_field('date_de_publication') . '</p>';
			}
		if(get_field('domaine'))
			{
				echo '<p><h4>DOMAINE</h4>' . get_field('domaine') . '</p>';
			}
			
			
			if(get_field('type'))
			{
				echo '<p><h4>TYPE</h4>' . get_field('type') . '</p>';
			}
			if(get_field('nom'))
			{
				echo '<p><h4>NOM</h4>' . get_field('nom') . '</p>';
			}
			if(get_field('localisation'))
			{
				echo '<p><h4>LOCALISATION</h4>' . get_field('localisation') . '</p>';
			}
			if(get_field('objectifs'))
			{
				echo '<p><h4>OBJECTIFS</h4>' . get_field('objectifs') . '</p>';
			}
			if(get_field('origine_du_dispositif'))
			{
				echo '<p><h4>ORIGINE DU DISPOSITIF</h4>' . get_field('origine_du_dispositif') . '</p>';
			}
			if(get_field('date_de_mise_en_oeuvre'))
			{
				echo '<p><h4>DATE DE MISE EN OEUVRE</h4>' . get_field('date_de_mise_en_oeuvre') . '</p>';
			}
			if(get_field('professionnels_impliques'))
			{
				echo '<p><h4>PROFESSIONNELS IMPLIQUES</h4>' . get_field('professionnels_impliques') . '</p>';
			}
			if(get_field('public_vise'))
			{
				echo '<p><h4>PUBLIC VISE</h4>' . get_field('public_vise') . '</p>';
			}
			if(get_field('capacite_daccueil'))
			{
				echo '<p><h4>CAPACITE D\'ACCUEIL</h4>' . get_field('capacite_daccueil') . '</p>';
			}
			if(get_field('descriptif_du_dispositif'))
			{
				echo '<p><h4>DESCRIPTIF DU DISPOSITIF</h4>' . get_field('descriptif_du_dispositif') . '</p>';
			}
			if(get_field('financement'))
			{
				echo '<p><h4>FINANCEMENT</h4>' . get_field('financement') . '</p>';
			}
			if(get_field('points_de_vigilance'))
			{
				echo '<p><h4>POINTS DE VIGILANCE</h4>' . get_field('points_de_vigilance') . '</p>';
			}
			if(get_field('evaluation'))
			{
				echo '<p><h4>EVALUATION</h4>' . get_field('evaluation') . '</p>';
			}
			if(get_field('reproductibilite'))
			{
				echo '<p><h4>REPRODUCTIBILITE</h4>' . get_field('reproductibilite') . '</p>';
			}
			if(get_field('le_point_de_vue_de_lunafam'))
			{
				echo '<p><h4>LE POINT DE VUE DE L\'UNAFAM</h4>' . get_field('le_point_de_vue_de_lunafam') . '</p>';
			}
			

			if(get_field('emploi_type'))
			{
				echo '<p><h4>TYPE</h4>' . get_field('emploi_type') . '</p>';
			}			
			if(get_field('emploi_nom'))
			{
				echo '<p><h4>NOM</h4>' . get_field('emploi_nom') . '</p>';
			}
			if(get_field('emploi_localisation'))
			{
				echo '<p><h4>LOCALISATION</h4>' . get_field('emploi_localisation') . '</p>';
			}
			if(get_field('emploi_acteurs'))
			{
				echo '<p><h4>ACTEURS</h4>' . get_field('emploi_acteurs') . '</p>';
			}
			if(get_field('emploi_date_de_mise_en_oeuvre'))
			{
				echo '<p><h4>DATE DE MISE EN OEUVRE</h4>' . get_field('emploi_date_de_mise_en_oeuvre') . '</p>';
			}
			if(get_field('emploi_cible_objectifs'))
			{
				echo '<p><h4>CIBLE / OBJECTIFS</h4>' . get_field('emploi_cible_objectifs') . '</p>';
			}
			if(get_field('emploi_nombre_de_personnes_handicapees'))
			{
				echo '<p><h4>NOMBRE DE PERSONNES HANDICAPEES</h4>' . get_field('emploi_nombre_de_personnes_handicapees') . '</p>';
			}
			if(get_field('emploi_description_detaillee_du_dispositif'))
			{
				echo '<p><h4>DESCRIPTION DETAILLEE DU DISPOSITIF</h4>' . get_field('emploi_description_detaillee_du_dispositif') . '</p>';
			}
			if(get_field('emploi_avis_des_professionnels'))
			{
				echo '<p><h4>AVIS DES PROFESSIONNELS</h4>' . get_field('emploi_avis_des_professionnels') . '</p>';
			}
			if(get_field('emploi_avis_des_beneficiaires'))
			{
				echo '<p><h4>AVIS DES BENEFICIAIRES</h4>' . get_field('emploi_avis_des_beneficiaires') . '</p>';
			}
			if(get_field('emploi_limites'))
			{
				echo '<p><h4>LIMITES</h4>' . get_field('emploi_limites') . '</p>';
			}
			if(get_field('emploi_partenariat'))
			{
				echo '<p><h4>PARTENARIAT</h4>' . get_field('emploi_partenariat') . '</p>';
			}
			if(get_field('emploi_experimentation'))
			{
				echo '<p><h4>EXPERIMENTATION</h4>' . get_field('emploi_experimentation') . '</p>';
			}
			
			
			if(get_field('psy-cible-indication'))
			{
				echo '<p><h4>CIBLE / INDICATION</h4>' . get_field('psy-cible-indication') . '</p>';
			}
			if(get_field('mode_d’adressage'))
			{
				echo '<p><h4>MODE D\'ADRESSAGE</h4>' . get_field('mode_d’adressage') . '</p>';
			}
			if(get_field('psy_objectifs_du_dispositif'))
			{
				echo '<p><h4>OBJECTIFS DU DISPOSITIF</h4>' . get_field('psy_objectifs_du_dispositif') . '</p>';
			}
			if(get_field('psy-description_de_la_pratique'))
			{
				echo '<p><h4>DESCRIPTION DE LA PRATIQUE</h4>' . get_field('psy-description_de_la_pratique') . '</p>';
			}
			if(get_field('psy-acteurs_et_temps_professionnel'))
			{
				echo '<p><h4>ACTEURS ET TEMPS PROFESSIONNEL</h4>' . get_field('psy-acteurs_et_temps_professionnel') . '</p>';
			}
			if(get_field('psy-avis_des_bénéficiaires'))
			{
				echo '<p><h4>AVIS DES BÉNÉFICIAIRES</h4>' . get_field('psy-avis_des_bénéficiaires') . '</p>';
			}
			if(get_field('psy-données_quantitatives'))
			{
				echo '<p><h4>DONNÉES QUANTITATIVES</h4>' . get_field('psy-données_quantitatives') . '</p>';
			}
			if(get_field('psy-coût'))
			{
				echo '<p><h4>COÛT</h4>' . get_field('psy-coût') . '</p>';
			}
			if(get_field('psy-lien_avec_les_aidants'))
			{
				echo '<p><h4>LIEN AVEC LES AIDANTS</h4>' . get_field('psy-lien_avec_les_aidants') . '</p>';
			}
			if(get_field('psy-difficultés_et_problématiques'))
			{
				echo '<p><h4>DIFFICULTÉS ET PROBLÉMATIQUES</h4>' . get_field('psy-difficultés_et_problématiques') . '</p>';
			}
			if(get_field('psy-lieu_de_soin_etablissement_de_rattachement'))
			{
				echo '<p><h4>LIEU DE SOIN ETABLISSEMENT DE RATTACHEMENT</h4>' . get_field('psy-lieu_de_soin_etablissement_de_rattachement') . '</p>';
			}
			if(get_field('psy-territoire_concerné'))
			{
				echo '<p><h4>TERRITOIRE CONCERNÉ</h4>' . get_field('psy-territoire_concerné') . '</p>';
			}
			if(get_field('psy-date_de_mise_en_œuvre'))
			{
				echo '<p><h4>DATE DE MISE EN ŒUVRE</h4>' . get_field('psy-date_de_mise_en_œuvre') . '</p>';
			}
		twentyseventeen_entry_footer();
	}
	?>

</article><!-- #post-## -->
